SexUI.POV.Part = {}
SexUI.POV.Part_mt = {
    __index = SexUI.POV.Part
}

--- Instantiates a new instance
-- @param actor an actor
-- @param part_name a string
function SexUI.POV.Part.new(actor, part_name)
  local self = setmetatable({}, SexUI.POV.Part_mt)
  local partName = part_name
  local actorGender = actor.subGender or actor.gender  
  if ((actor.gender == "male") and (actor.subGender == "futanari")) then actorGender = "malefuta" end
  if (partName == "body_overlay") or (actor.actorSlot == "actor2" and partName == "genital") then
        self.image = self:buildImagePreg(actor.actorSlot, part_name, actorGender, actor.species, actor.isPregnant)
    elseif (partName == "hair") then
        if (actor.entityType == "humanoid") then self.image = self:buildHairImage(actor.actorSlot, actor.hairID, actor.species) 
        else self.image = "/assetmissing.png"
        end
    else
        self.image = self:buildImage(actor.actorSlot, part_name, actorGender, actor.species)
  end
  
  if (partName == "hair") then
    self.directives = actor.hairDirectives or ""
    self.directives = self.directives .. (actor.bodyDirectives or "")
  else
    self.directives = actor.bodyDirectives or ""
    self.directives = self.directives .. (actor.hairDirectives or "")
  end
  return self
end

function SexUI.POV.Part.newHair(actor, part_name, using_default)
  local self = setmetatable({}, SexUI.POV.Part_mt)
  if actor.entityType == "humanoid" then 
    local partName = part_name
    self.image = self:buildDefaultHair(actor.actorSlot, actor.gender, actor.species)
    
    self.directives = actor.hairDirectives or ""
    self.directives = self.directives .. (actor.bodyDirectives or "")
    return self
  else
    self.image = "/assetmissing.png"
    self.directives = ""
    return self
  end
end

--- Checks if the part's assigned image exists
function SexUI.POV.Part:checkImageExists()
  return Sexbound.Util.imageExists(self.image)
end

--- Builds an image path for this instance of part, accounting for pregnancy.
-- @param role
-- @param part_name
-- @param gender
-- @param species
-- @param pregnantStatus
function SexUI.POV.Part:buildImagePreg(role, part_name, gender, species, pregnantStatus)
  local filepath = "/artwork/pov/<role>/<species>/<gender>/<part_name><pregnantStatus>.png"
  --filepath = util.replaceTag(filepath, "entityGroup", actorGroup)
  filepath = util.replaceTag(filepath, "species", species)
  filepath = util.replaceTag(filepath, "gender", gender)
  filepath = util.replaceTag(filepath, "role", role)
  filepath = util.replaceTag(filepath, "part_name", part_name)
  if (pregnantStatus == true) then 
    filepath = util.replaceTag(filepath, "pregnantStatus", "preg")
  else
    filepath = util.replaceTag(filepath, "pregnantStatus", "")
  end
  return filepath
end

--- Builds an image path for this instance of part.
-- @param role
-- @param part_name
-- @param gender
-- @param species
function SexUI.POV.Part:buildImage(role, part_name, gender, species)
  local filepath = "/artwork/pov/<role>/<species>/<gender>/<part_name>.png"
  --filepath = util.replaceTag(filepath, "entityGroup", actorGroup)
  filepath = util.replaceTag(filepath, "species", species)
  filepath = util.replaceTag(filepath, "gender", gender)
  filepath = util.replaceTag(filepath, "role", role)
  filepath = util.replaceTag(filepath, "part_name", part_name)

  return filepath
end

--- Builds an image path for this instance of part, specifically for hair.
-- @param role
-- @param part_name
-- @param species
function SexUI.POV.Part:buildHairImage(role, hairID, species)
  local filepath = "/artwork/pov/<role>/<species>/hair/<hair_name>.png"
  --filepath = util.replaceTag(filepath, "entityGroup", actorGroup)
  filepath = util.replaceTag(filepath, "species", species)
  --filepath = util.replaceTag(filepath, "gender", gender)
  filepath = util.replaceTag(filepath, "role", role)
  filepath = util.replaceTag(filepath, "hair_name", hairID)
  return filepath
end
function SexUI.POV.Part:buildDefaultHair(role, gender, species)
  local filepath = "/artwork/pov/<role>/<species>/hair/<gender>default.png"
  --filepath = util.replaceTag(filepath, "entityGroup", actorGroup)
  filepath = util.replaceTag(filepath, "species", species)
  filepath = util.replaceTag(filepath, "gender", gender)
  filepath = util.replaceTag(filepath, "role", role)
  --filepath = util.replaceTag(filepath, "part_name", defaultVar)
  return filepath
end

--- Draws this part's image to the specified canvas
-- @param canvas
-- @param frame
function SexUI.POV.Part:render(canvas, frame)
  canvas:drawImage(self.image .. ":" .. frame .. (self.directives or ""), {0, 0}, 1, "white", false)
end